﻿using log4net;
using System;
using System.Threading.Tasks;
using VA.PPMS.IWS.ValidationDataService.Data;
using VA.PPMS.IWS.ValidationDataService.Interface;

namespace VA.PPMS.IWS.ValidationDataService
{
    public class ValidationDataService : IValidationDataService
    {
        private readonly ILog _logger;
        private readonly NppesData _nppesData;

        public ValidationDataService(ILog logger, NppesData nppesData)
        {
            _logger = logger;
            _nppesData = nppesData;

        }

        public async Task ProcessData()
        {
            try
            {
                _logger.Info($"@@@@ INFO - Start ValidationDataService at: {DateTime.Now} @@@@");

                await _nppesData.ProcessCurrentData();

                _logger.Info($"@@@@ INFO - End ValidationDataService at: {DateTime.Now} @@@@");
            }
            catch (Exception ex)
            {
                _logger.Error("@@@@ ERROR - There was a problem with the ValidationDataService @@@@", ex);
                throw;
            }
        }
    }
}